IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[PDV_VD_CONSOLIDACAO_XML]')) 
	begin
		return;
	end
else
begin
CREATE TABLE [dbo].[PDV_VD_CONSOLIDACAO_XML](
	[CD_EMP] [int] NOT NULL,
	[CD_FILIAL] [int] NOT NULL,
	[CD_VD] [int] NOT NULL,
	[XML] [xml] NOT NULL,
 CONSTRAINT [PK_PDV_VD_CONSOLIDACAO_XML] PRIMARY KEY CLUSTERED 
(
	[CD_EMP] ASC,
	[CD_FILIAL] ASC,
	[CD_VD] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

ALTER TABLE [dbo].[PDV_VD_CONSOLIDACAO_XML] ADD  CONSTRAINT [DF_PDV_VD_CONSOLIDACAO_XML_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

ALTER TABLE [dbo].[PDV_VD_CONSOLIDACAO_XML] ADD  CONSTRAINT [DF_PDV_VD_CONSOLIDACAO_XML_CD_FILIAL]  DEFAULT ((0)) FOR [CD_FILIAL]

ALTER TABLE [dbo].[PDV_VD_CONSOLIDACAO_XML] ADD  CONSTRAINT [DF_PDV_VD_CONSOLIDACAO_XML_CD_VD]  DEFAULT ((0)) FOR [CD_VD]

ALTER TABLE [dbo].[PDV_VD_CONSOLIDACAO_XML]  WITH CHECK ADD  CONSTRAINT [FK_PDV_VD_CONSOLIDACAO_XML_PDV_VD] FOREIGN KEY([CD_VD], [CD_FILIAL], [CD_EMP])
REFERENCES [dbo].[PDV_VD] ([CD_VD], [CD_FILIAL], [CD_EMP])
ON DELETE CASCADE

ALTER TABLE [dbo].[PDV_VD_CONSOLIDACAO_XML] CHECK CONSTRAINT [FK_PDV_VD_CONSOLIDACAO_XML_PDV_VD]
end

